/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.common.SuppressForbidden;
import io.crate.common.annotations.VisibleForTesting;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;

public class MultiException
extends RuntimeException {
    private static final int MAX_EXCEPTION_LENGTH = 10000;
    private final Collection<? extends Throwable> exceptions;

    public MultiException(Collection<? extends Throwable> exceptions) {
        this.exceptions = exceptions;
    }

    @Override
    @SuppressForbidden(reason="Throwable#printStackTrace")
    public void printStackTrace() {
        for (Throwable throwable : this.exceptions) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        for (Throwable throwable : this.exceptions) {
            throwable.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        for (Throwable throwable : this.exceptions) {
            throwable.printStackTrace(s);
        }
    }

    @Override
    public String getMessage() {
        StringJoiner joiner = new StringJoiner("\n");
        for (Throwable throwable : this.exceptions) {
            joiner.add(throwable.getMessage());
            if (joiner.length() <= 10000) continue;
            joiner.add("too much output. output truncated.");
            break;
        }
        return joiner.toString();
    }

    @VisibleForTesting
    Collection<? extends Throwable> getExceptions() {
        return this.exceptions;
    }

    public static MultiException of(Throwable prevError, Throwable newError) {
        if (prevError instanceof MultiException) {
            Collection<? extends Throwable> prevExceptions = ((MultiException)prevError).getExceptions();
            ArrayList<? extends Throwable> errors = new ArrayList<Throwable>(prevExceptions.size() + 1);
            errors.addAll(prevExceptions);
            errors.add(newError);
            return new MultiException(errors);
        }
        return new MultiException(List.of(prevError, newError));
    }
}

