/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import java.util.Collections;
import java.util.Locale;

public class InvalidRelationName
extends RuntimeException
implements TableScopeException {
    private final RelationName ident;

    InvalidRelationName(String indexName, Throwable e) {
        super(String.format(Locale.ENGLISH, "Relation name \"%s\" is invalid.", indexName), e);
        this.ident = RelationName.fromIndexName(indexName);
    }

    public InvalidRelationName(RelationName ident) {
        super(String.format(Locale.ENGLISH, "Relation name \"%s\" is invalid.", ident.fqn()));
        this.ident = ident;
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return Collections.singletonList(this.ident);
    }
}

