/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

public final class Exceptions {
    private Exceptions() {
    }

    public static void rethrowUnchecked(Throwable ex) {
        Exceptions.rethrow(ex);
    }

    public static <T> T rethrowRuntimeException(Throwable t) {
        throw Exceptions.toRuntimeException(t);
    }

    public static Exception toException(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new RuntimeException(t);
    }

    public static RuntimeException toRuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    private static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }

    public static String userFriendlyMessageInclNested(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                sb.append(t.getClass().getSimpleName());
                if (t.getMessage() != null) {
                    sb.append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                }
                sb.append("; ");
                if ((t = t.getCause()) == null) continue;
                sb.append("nested: ");
            }
            return sb.toString();
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }

    public static String userFriendlyMessage(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }
}

