/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import java.util.Collections;
import java.util.Locale;

public class ColumnValidationException
extends RuntimeException
implements TableScopeException {
    private final RelationName relationName;

    public ColumnValidationException(String column, RelationName relationName, String message) {
        super(String.format(Locale.ENGLISH, "Validation failed for %s: %s", column, message));
        this.relationName = relationName;
    }

    public ColumnValidationException(String column, RelationName relationName, Throwable e) {
        super(String.format(Locale.ENGLISH, "Validation failed for %s: %s", column, e.getMessage()));
        this.relationName = relationName;
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return Collections.singletonList(this.relationName);
    }
}

