/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.analyze.TableIdentsExtractor;
import io.crate.exceptions.TableScopeException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import java.util.Locale;

public class AmbiguousColumnException
extends RuntimeException
implements TableScopeException {
    private final Symbol columnSymbol;

    public AmbiguousColumnException(ColumnIdent columnPath, Symbol columnSymbol) {
        super(String.format(Locale.ENGLISH, "Column \"%s\" is ambiguous", columnPath.sqlFqn()));
        this.columnSymbol = columnSymbol;
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return TableIdentsExtractor.extract(this.columnSymbol);
    }
}

