/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data.join;

import io.crate.data.BatchIterator;
import io.crate.data.join.ElementCombiner;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class SemiJoinNLBatchIterator<L, R, C>
implements BatchIterator<L> {
    final BatchIterator<L> left;
    final BatchIterator<R> right;
    final ElementCombiner<L, R, C> combiner;
    final Predicate<C> joinCondition;
    BatchIterator<?> activeIt;

    public SemiJoinNLBatchIterator(BatchIterator<L> left, BatchIterator<R> right, ElementCombiner<L, R, C> combiner, Predicate<C> joinCondition) {
        this.left = left;
        this.right = right;
        this.combiner = combiner;
        this.joinCondition = joinCondition;
        this.activeIt = left;
    }

    @Override
    public L currentElement() {
        return this.left.currentElement();
    }

    @Override
    public void moveToStart() {
        this.left.moveToStart();
        this.right.moveToStart();
        this.activeIt = this.left;
    }

    @Override
    public boolean moveNext() {
        Boolean rightAdvanced;
        do {
            if (this.activeIt != this.left) continue;
            return this.moveLeftSide();
        } while ((rightAdvanced = this.tryAdvanceRight()) == null);
        return rightAdvanced;
    }

    @Override
    public void close() {
        this.left.close();
        this.right.close();
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        return this.activeIt.loadNextBatch();
    }

    @Override
    public boolean allLoaded() {
        return this.activeIt.allLoaded();
    }

    private boolean moveLeftSide() {
        while (this.tryMoveLeft()) {
            this.activeIt = this.right;
            Boolean rightAdvanced = this.tryAdvanceRight();
            if (rightAdvanced == null) continue;
            return rightAdvanced;
        }
        this.activeIt = this.left;
        return false;
    }

    protected Boolean tryAdvanceRight() {
        while (this.tryMoveRight()) {
            if (!this.joinCondition.test(this.combiner.currentElement())) continue;
            this.right.moveToStart();
            this.combiner.setRight(this.right.currentElement());
            this.activeIt = this.left;
            return true;
        }
        if (!this.right.allLoaded()) {
            return false;
        }
        this.right.moveToStart();
        this.combiner.setRight(this.right.currentElement());
        this.activeIt = this.left;
        return null;
    }

    @Override
    public void kill(@Nonnull Throwable throwable) {
        this.left.kill(throwable);
        this.right.kill(throwable);
    }

    private boolean tryMoveLeft() {
        if (this.left.moveNext()) {
            this.combiner.setLeft(this.left.currentElement());
            return true;
        }
        return false;
    }

    boolean tryMoveRight() {
        if (this.right.moveNext()) {
            this.combiner.setRight(this.right.currentElement());
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLazyResultSet() {
        return false;
    }
}

