/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data.join;

import io.crate.data.BatchIterator;
import io.crate.data.join.ElementCombiner;
import io.crate.data.join.JoinBatchIterator;
import java.util.function.Predicate;

public class LeftJoinNLBatchIterator<L, R, C>
extends JoinBatchIterator<L, R, C> {
    private final Predicate<C> joinCondition;
    private boolean hadMatch = false;

    public LeftJoinNLBatchIterator(BatchIterator<L> left, BatchIterator<R> right, ElementCombiner<L, R, C> combiner, Predicate<C> joinCondition) {
        super(left, right, combiner);
        this.joinCondition = joinCondition;
    }

    @Override
    public boolean moveNext() {
        while (this.activeIt != this.left) {
            Boolean x = this.tryAdvanceRight();
            if (x != null) {
                return x;
            }
            this.activeIt = this.left;
        }
        return this.moveLeftSide();
    }

    private boolean moveLeftSide() {
        this.activeIt = this.right;
        while (this.tryMoveLeft()) {
            Boolean x = this.tryAdvanceRight();
            if (x == null) continue;
            return x;
        }
        this.activeIt = this.left;
        return false;
    }

    private Boolean tryAdvanceRight() {
        while (this.tryMoveRight()) {
            if (!this.joinCondition.test(this.combiner.currentElement())) continue;
            this.hadMatch = true;
            return true;
        }
        if (!this.right.allLoaded()) {
            return false;
        }
        this.right.moveToStart();
        if (!this.hadMatch) {
            this.activeIt = this.left;
            this.combiner.nullRight();
            return true;
        }
        this.hadMatch = false;
        return null;
    }
}

