/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data.join;

import io.crate.data.BatchIterator;
import io.crate.data.join.ElementCombiner;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public abstract class JoinBatchIterator<L, R, C>
implements BatchIterator<C> {
    protected final ElementCombiner<L, R, C> combiner;
    protected final BatchIterator<L> left;
    protected final BatchIterator<R> right;
    protected BatchIterator activeIt;

    protected JoinBatchIterator(BatchIterator<L> left, BatchIterator<R> right, ElementCombiner<L, R, C> combiner) {
        this.left = left;
        this.right = right;
        this.activeIt = left;
        this.combiner = combiner;
    }

    @Override
    public C currentElement() {
        return this.combiner.currentElement();
    }

    @Override
    public void moveToStart() {
        this.left.moveToStart();
        this.right.moveToStart();
        this.activeIt = this.left;
    }

    boolean tryMoveLeft() {
        if (this.left.moveNext()) {
            this.combiner.setLeft(this.left.currentElement());
            return true;
        }
        return false;
    }

    boolean tryMoveRight() {
        if (this.right.moveNext()) {
            this.combiner.setRight(this.right.currentElement());
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.left.close();
        this.right.close();
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        return this.activeIt.loadNextBatch();
    }

    @Override
    public boolean allLoaded() {
        return this.activeIt.allLoaded();
    }

    @Override
    public void kill(@Nonnull Throwable throwable) {
        this.left.kill(throwable);
        this.right.kill(throwable);
    }

    @Override
    public boolean hasLazyResultSet() {
        return this.left.hasLazyResultSet() || this.right.hasLazyResultSet();
    }
}

