/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data.join;

import io.crate.data.Row;
import io.crate.data.join.ElementCombiner;

public class CombinedRow
extends Row
implements ElementCombiner<Row, Row, Row> {
    private final int numCols;
    private final int leftNumCols;
    private Row left;
    private Row right;

    public CombinedRow(int leftNumCols, int rightNumCols) {
        this.leftNumCols = leftNumCols;
        this.numCols = leftNumCols + rightNumCols;
    }

    @Override
    public int numColumns() {
        return this.numCols;
    }

    @Override
    public Object get(int index) {
        if (index < this.leftNumCols) {
            if (this.left == null) {
                return null;
            }
            return this.left.get(index);
        }
        index -= this.leftNumCols;
        if (this.right == null) {
            return null;
        }
        return this.right.get(index);
    }

    @Override
    public Row currentElement() {
        return this;
    }

    @Override
    public void nullLeft() {
        this.left = null;
    }

    @Override
    public void nullRight() {
        this.right = null;
    }

    @Override
    public void setRight(Row o) {
        this.right = o;
    }

    @Override
    public void setLeft(Row o) {
        this.left = o;
    }

    public String toString() {
        return "CombinedRow{lhs=" + this.left + ", rhs=" + this.right + "}";
    }
}

