/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import io.crate.exceptions.Exceptions;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InMemoryBatchIterator<T>
implements BatchIterator<T> {
    private final Iterable<? extends T> items;
    private final T sentinel;
    private final boolean hasLazyResultSet;
    private volatile Throwable killed = null;
    private Iterator<? extends T> it;
    private T current;

    public static <T> BatchIterator<T> empty(@Nullable T sentinel) {
        return InMemoryBatchIterator.of(Collections.emptyList(), sentinel, false);
    }

    public static <T> BatchIterator<T> of(T item, @Nullable T sentinel) {
        return InMemoryBatchIterator.of(Collections.singletonList(item), sentinel, false);
    }

    public static <T> BatchIterator<T> of(Iterable<? extends T> items, @Nullable T sentinel, boolean hasLazyResultSet) {
        return new InMemoryBatchIterator<T>(items, sentinel, hasLazyResultSet);
    }

    public InMemoryBatchIterator(Iterable<? extends T> items, T sentinel, boolean hasLazyResultSet) {
        this.items = items;
        this.it = items.iterator();
        this.current = sentinel;
        this.sentinel = sentinel;
        this.hasLazyResultSet = hasLazyResultSet;
    }

    @Override
    public T currentElement() {
        return this.current;
    }

    @Override
    public void moveToStart() {
        this.raiseIfKilled();
        this.it = this.items.iterator();
        this.current = this.sentinel;
    }

    @Override
    public boolean moveNext() {
        this.raiseIfKilled();
        if (this.it.hasNext()) {
            this.current = this.it.next();
            return true;
        }
        this.current = this.sentinel;
        return false;
    }

    @Override
    public void close() {
        this.killed = BatchIterator.CLOSED;
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        throw new IllegalStateException("All batches already loaded");
    }

    @Override
    public boolean allLoaded() {
        return true;
    }

    @Override
    public void kill(@Nonnull Throwable throwable) {
        this.killed = throwable;
    }

    @Override
    public boolean hasLazyResultSet() {
        return this.hasLazyResultSet;
    }

    private void raiseIfKilled() {
        if (this.killed != null) {
            Exceptions.rethrowUnchecked(this.killed);
        }
    }
}

