/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class FlatMapBatchIterator<TIn, TOut>
implements BatchIterator<TOut> {
    private final BatchIterator<TIn> source;
    private final Function<TIn, ? extends Iterator<TOut>> mapper;
    private TOut current = null;
    private boolean onSourceRow = false;
    private Iterator<TOut> mappedElements;

    public FlatMapBatchIterator(BatchIterator<TIn> source, Function<TIn, ? extends Iterator<TOut>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public TOut currentElement() {
        return this.current;
    }

    @Override
    public void moveToStart() {
        this.current = null;
        this.mappedElements = null;
        this.onSourceRow = false;
        this.source.moveToStart();
    }

    @Override
    public boolean moveNext() {
        while (true) {
            if (this.onSourceRow) {
                if (this.mappedElements == null) {
                    this.mappedElements = this.mapper.apply(this.source.currentElement());
                }
                if (this.mappedElements.hasNext()) {
                    this.current = this.mappedElements.next();
                    return true;
                }
                this.onSourceRow = false;
                this.mappedElements = null;
                continue;
            }
            this.onSourceRow = this.source.moveNext();
            if (!this.onSourceRow) break;
        }
        return false;
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        return this.source.loadNextBatch();
    }

    @Override
    public boolean allLoaded() {
        return this.source.allLoaded();
    }

    @Override
    public void kill(@Nonnull Throwable throwable) {
        this.source.kill(throwable);
    }

    @Override
    public boolean hasLazyResultSet() {
        return this.source.hasLazyResultSet();
    }
}

