/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import io.crate.data.BatchIterators;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.exceptions.Exceptions;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CollectingBatchIterator<T>
implements BatchIterator<T> {
    private final Supplier<CompletableFuture<? extends Iterable<? extends T>>> loadItems;
    private final Runnable onClose;
    private final Consumer<? super Throwable> onKill;
    private final boolean involvesIO;
    private CompletableFuture<? extends Iterable<? extends T>> resultFuture;
    private Iterator<? extends T> it = Collections.emptyIterator();
    private T current;
    private volatile Throwable killed;

    private CollectingBatchIterator(Supplier<CompletableFuture<? extends Iterable<? extends T>>> loadItems, Runnable onClose, Consumer<? super Throwable> onKill, boolean involvesIO) {
        this.loadItems = loadItems;
        this.onClose = onClose;
        this.onKill = onKill;
        this.involvesIO = involvesIO;
    }

    public static BatchIterator<Row> summingLong(BatchIterator<Row> source) {
        return CollectingBatchIterator.newInstance(source, Collectors.collectingAndThen(Collectors.summingLong((? super T r) -> (Long)r.get(0)), sum -> Collections.singletonList(new Row1(sum))));
    }

    public static <T, A> BatchIterator<T> newInstance(BatchIterator<T> source, Collector<T, A, ? extends Iterable<? extends T>> collector) {
        return CollectingBatchIterator.newInstance(source::close, source::kill, () -> BatchIterators.collect(source, collector), source.hasLazyResultSet());
    }

    public static <I, O> BatchIterator<O> newInstance(BatchIterator<I> source, Function<BatchIterator<I>, CompletableFuture<? extends Iterable<? extends O>>> processSource, boolean involvesIO) {
        return CollectingBatchIterator.newInstance(source::close, source::kill, () -> ((CompletableFuture)processSource.apply(source)).whenComplete((r, f) -> source.close()), involvesIO);
    }

    public static <T> BatchIterator<T> newInstance(Runnable onClose, Consumer<? super Throwable> onKill, Supplier<CompletableFuture<? extends Iterable<? extends T>>> loadItems, boolean involvesIO) {
        return new CollectingBatchIterator<T>(loadItems, onClose, onKill, involvesIO);
    }

    @Override
    public T currentElement() {
        return this.current;
    }

    @Override
    public void moveToStart() {
        this.raiseIfKilled();
        if (this.resultFuture != null) {
            if (!this.resultFuture.isDone()) {
                throw new IllegalStateException("BatchIterator is loading");
            }
            this.it = this.resultFuture.join().iterator();
        }
        this.current = null;
    }

    @Override
    public boolean moveNext() {
        this.raiseIfKilled();
        if (this.it.hasNext()) {
            this.current = this.it.next();
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    public void close() {
        this.onClose.run();
        this.killed = BatchIterator.CLOSED;
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        if (this.resultFuture == null) {
            this.resultFuture = this.loadItems.get().whenComplete((r, t) -> {
                if (t != null) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException((Throwable)t);
                }
                this.it = r.iterator();
            });
            return this.resultFuture;
        }
        throw new IllegalStateException("BatchIterator already loaded");
    }

    @Override
    public boolean allLoaded() {
        return this.resultFuture != null;
    }

    @Override
    public void kill(@Nonnull Throwable throwable) {
        this.onKill.accept(throwable);
        this.killed = throwable;
    }

    @Override
    public boolean hasLazyResultSet() {
        return this.involvesIO;
    }

    private void raiseIfKilled() {
        if (this.killed != null) {
            Exceptions.rethrowUnchecked(this.killed);
        }
    }
}

