/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public final class CapturingRowConsumer
implements RowConsumer {
    private final CompletableFuture<BatchIterator<Row>> batchIterator = new CompletableFuture();
    private final CompletableFuture<?> completionFuture;
    private final boolean requiresScroll;

    public CapturingRowConsumer(boolean requiresScroll, CompletableFuture<?> completionFuture) {
        this.completionFuture = completionFuture;
        this.requiresScroll = requiresScroll;
    }

    @Override
    public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
        if (failure == null) {
            this.batchIterator.complete(iterator);
        } else {
            this.batchIterator.completeExceptionally(failure);
        }
    }

    public CompletableFuture<BatchIterator<Row>> capturedBatchIterator() {
        return this.batchIterator;
    }

    @Override
    public CompletableFuture<?> completionFuture() {
        return this.completionFuture;
    }

    @Override
    public boolean requiresScroll() {
        return this.requiresScroll;
    }

    public String toString() {
        return "CapturingRowConsumer{captured=" + this.batchIterator.isDone() + "}";
    }
}

