/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import io.crate.data.MappedForwardingBatchIterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class BatchIterators {
    public static <T, A, R> CompletableFuture<R> collect(BatchIterator<T> it, Collector<T, A, R> collector) {
        return BatchIterators.collect(it, collector.supplier().get(), collector, new CompletableFuture());
    }

    public static <T, A, R> CompletableFuture<R> collect(BatchIterator<T> it, A state, Collector<T, A, R> collector, CompletableFuture<R> resultFuture) {
        BiConsumer<A, A> accumulator = collector.accumulator();
        try {
            while (it.moveNext()) {
                accumulator.accept(state, it.currentElement());
            }
            if (it.allLoaded()) {
                resultFuture.complete(collector.finisher().apply(state));
            } else {
                it.loadNextBatch().whenComplete((r, t) -> {
                    if (t == null) {
                        BatchIterators.collect(it, state, collector, resultFuture);
                    } else {
                        resultFuture.completeExceptionally((Throwable)t);
                    }
                });
            }
        }
        catch (Throwable t2) {
            resultFuture.completeExceptionally(t2);
        }
        return resultFuture;
    }

    public static <T, A> BatchIterator<A> partition(final BatchIterator<T> bi, final int size, final Supplier<A> supplier, final BiConsumer<A, T> accumulator, final Predicate<? super A> stateLimiter) {
        return new MappedForwardingBatchIterator<T, A>(){
            private A element = null;
            private A state = supplier.get();
            private int idx = 0;

            @Override
            protected BatchIterator<T> delegate() {
                return bi;
            }

            @Override
            public boolean moveNext() {
                boolean stateLimitReached = false;
                while (this.idx < size && !stateLimitReached && bi.moveNext()) {
                    accumulator.accept(this.state, bi.currentElement());
                    stateLimitReached = stateLimiter.test(this.state);
                    ++this.idx;
                }
                if (this.idx == size || stateLimitReached || this.idx > 0 && bi.allLoaded()) {
                    this.element = this.state;
                    this.state = supplier.get();
                    this.idx = 0;
                    return true;
                }
                this.element = null;
                return false;
            }

            @Override
            public A currentElement() {
                return this.element;
            }
        };
    }

    public static <I, O> BatchIterator<O> map(final BatchIterator<I> bi, final Function<? super I, ? extends O> mapper) {
        return new MappedForwardingBatchIterator<I, O>(){

            @Override
            public O currentElement() {
                return mapper.apply(bi.currentElement());
            }

            @Override
            protected BatchIterator<I> delegate() {
                return bi;
            }
        };
    }
}

