/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.Bucket;
import io.crate.data.Row;
import io.crate.data.RowN;
import java.util.Iterator;

public class ArrayBucket
implements Bucket {
    private final Object[][] rows;
    private final int numColumns;

    public ArrayBucket(Object[][] rows, int numColumns) {
        this.rows = rows;
        this.numColumns = numColumns;
    }

    public ArrayBucket(Object[][] rows) {
        this.rows = rows;
        this.numColumns = rows.length > 0 ? rows[0].length : -1;
    }

    @Override
    public int size() {
        return this.rows.length;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){
            int pos = 0;
            final RowN row;
            {
                this.row = new RowN(ArrayBucket.this.numColumns);
            }

            @Override
            public boolean hasNext() {
                return this.pos < ArrayBucket.this.rows.length;
            }

            @Override
            public Row next() {
                this.row.cells(ArrayBucket.this.rows[this.pos++]);
                return this.row;
            }

            @Override
            public void remove() {
            }
        };
    }

    public String toString() {
        return "ArrayBucket{numRows=" + this.rows.length + ", numColumns=" + this.numColumns + "}";
    }
}

