/*
 * Decompiled with CFR 0.152.
 */
package io.crate.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class CountdownFutureCallback
extends CompletableFuture<Void>
implements BiConsumer<Object, Throwable> {
    private final AtomicInteger counter;
    private final AtomicReference<Throwable> lastFailure = new AtomicReference();

    public CountdownFutureCallback(int numCalls) {
        this.counter = new AtomicInteger(numCalls);
    }

    public void onSuccess() {
        this.countdown();
    }

    public void onFailure(@Nonnull Throwable t) {
        this.lastFailure.set(t);
        this.countdown();
    }

    private void countdown() {
        if (this.counter.decrementAndGet() == 0) {
            Throwable throwable = this.lastFailure.get();
            if (throwable == null) {
                this.complete(null);
            } else {
                this.completeExceptionally(throwable);
            }
        }
    }

    @Override
    public void accept(Object o, Throwable t) {
        if (t == null) {
            this.onSuccess();
        } else {
            this.onFailure(t);
        }
    }
}

