/*
 * Decompiled with CFR 0.152.
 */
package io.crate.concurrent;

import io.crate.common.SuppressForbidden;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public final class CompletableFutures {
    private CompletableFutures() {
    }

    public static <T> CompletableFuture<List<T>> allAsList(Collection<? extends CompletableFuture<? extends T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(aVoid -> {
            ArrayList results = new ArrayList(futures.size());
            for (CompletableFuture future : futures) {
                results.add(future.join());
            }
            return results;
        });
    }

    @SuppressForbidden(reason="This is the wrapper for supplyAsync that should be used - it handles exceptions")
    public static <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        try {
            return CompletableFuture.supplyAsync(supplier, executor);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }
}

