/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Sorted {
    public static Map<String, Object> sortRecursive(Map<String, Object> map) {
        return Sorted.sortRecursive(map, false);
    }

    public static LinkedHashMap<String, Object> sortRecursive(Map<String, Object> map, boolean sortOnlyMaps) {
        LinkedHashMap<String, Object> sortedMap = new LinkedHashMap<String, Object>(map.size(), 1.0f);
        ArrayList<String> sortedKeys = new ArrayList<String>(map.keySet());
        Collections.sort(sortedKeys);
        for (String sortedKey : sortedKeys) {
            Object o = map.get(sortedKey);
            if (o instanceof Map) {
                sortedMap.put(sortedKey, Sorted.sortRecursive((Map)o, sortOnlyMaps));
                continue;
            }
            if (o instanceof Collection) {
                sortedMap.put(sortedKey, sortOnlyMaps ? o : Sorted.sortRecursive((Collection)o));
                continue;
            }
            sortedMap.put(sortedKey, o);
        }
        return sortedMap;
    }

    public static Collection sortRecursive(Collection collection) {
        if (collection.size() == 0) {
            return collection;
        }
        Object firstElement = collection.iterator().next();
        if (firstElement instanceof Map) {
            ArrayList<LinkedHashMap<String, Object>> sortedList = new ArrayList<LinkedHashMap<String, Object>>(collection.size());
            for (Object obj : collection) {
                sortedList.add(Sorted.sortRecursive((Map)obj, true));
            }
            Collections.sort(sortedList);
            return sortedList;
        }
        ArrayList sortedList = new ArrayList(collection);
        Collections.sort(sortedList);
        return sortedList;
    }
}

