/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class RingBuffer<T>
implements Iterable<T> {
    private final T[] buf;
    private int pos = 0;

    public RingBuffer(int size) {
        this.buf = new Object[size];
    }

    public void add(T x) {
        this.buf[this.pos % this.buf.length] = x;
        ++this.pos;
    }

    public void reset() {
        this.pos = 0;
        Arrays.fill(this.buf, null);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int idx = -1;

            @Override
            public boolean hasNext() {
                return this.idx + 1 < RingBuffer.this.buf.length && RingBuffer.this.buf[this.idx + 1] != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("RingBuffer iterator has no more elements");
                }
                ++this.idx;
                return RingBuffer.this.buf[this.idx];
            }
        };
    }
}

