/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;

public class RefCountedItem<T>
implements AutoCloseable {
    private final Function<String, T> itemFactory;
    private final Consumer<T> closeItem;
    private final ArrayList<String> sources = new ArrayList();
    private int refs = 0;
    private T item;

    public RefCountedItem(Function<String, T> itemFactory, Consumer<T> closeItem) {
        this.itemFactory = itemFactory;
        this.closeItem = closeItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAcquired(String source) {
        ArrayList<String> arrayList = this.sources;
        synchronized (arrayList) {
            this.sources.add(source);
            ++this.refs;
            if (this.item == null) {
                this.item = this.itemFactory.apply(source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T item() {
        ArrayList<String> arrayList = this.sources;
        synchronized (arrayList) {
            if (this.item == null) {
                assert (!this.sources.isEmpty()) : "Must call `markAcquired` to be able to access the item";
                this.item = this.itemFactory.apply(this.sources.get(this.sources.size() - 1));
            }
            return this.item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<String> arrayList = this.sources;
        synchronized (arrayList) {
            --this.refs;
            if (this.refs == 0) {
                try {
                    this.closeItem.accept(this.item);
                }
                finally {
                    this.item = null;
                }
            }
        }
    }
}

