/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import io.crate.common.StringUtils;
import io.crate.common.TriConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.annotation.Nullable;

public final class Maps {
    public static <K, V> Map<K, V> concat(Map<K, V> m1, Map<K, V> m2) {
        if (m1.isEmpty()) {
            return m2;
        }
        if (m2.isEmpty()) {
            return m1;
        }
        HashMap<K, V> result = new HashMap<K, V>();
        result.putAll(m1);
        result.putAll(m2);
        return Collections.unmodifiableMap(result);
    }

    public static <T> T get(Map<String, ?> map, String key) {
        return (T)map.get(key);
    }

    public static <T> T getOrDefault(@Nullable Map<String, Object> map, String key, T defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        return (T)map.getOrDefault(key, defaultValue);
    }

    @Nullable
    public static Object getByPath(Map<String, Object> map, String path) {
        assert (path != null) : "path should not be null";
        return Maps.getByPath(map, StringUtils.splitToList('.', path));
    }

    @Nullable
    public static Object getByPath(Map<String, Object> value, List<String> path) {
        assert (path instanceof RandomAccess) : "Path must support random access for fast iteration";
        Map map = value;
        for (int i = 0; i < path.size(); ++i) {
            String key = path.get(i);
            Object val = map.get(key);
            if (i + 1 == path.size()) {
                return val;
            }
            if (!(val instanceof Map)) {
                return null;
            }
            map = (Map)val;
        }
        return map;
    }

    @Nullable
    public static <T> T removeByPath(Map<String, T> map, List<String> path) {
        assert (path instanceof RandomAccess) : "`path` must support random access for performance";
        Map m = map;
        for (int i = 0; i < path.size(); ++i) {
            String key = path.get(i);
            if (i + 1 == path.size()) {
                return m.remove(key);
            }
            T val = map.get(key);
            if (!(val instanceof Map)) {
                return null;
            }
            m = (Map)val;
        }
        return null;
    }

    public static void mergeInto(Map<String, Object> source, String key, List<String> path, Object value) {
        Maps.mergeInto(source, key, path, value, Map::put);
    }

    public static void mergeInto(Map<String, Object> source, String key, List<String> path, Object value, TriConsumer<Map<String, Object>, String, Object> writer) {
        if (path.isEmpty()) {
            writer.accept(source, key, value);
        } else if (source.containsKey(key)) {
            HashMap<String, Object> contents = (HashMap<String, Object>)source.get(key);
            if (contents == null) {
                contents = new HashMap<String, Object>();
                source.put(key, contents);
            }
            String nextKey = path.get(0);
            Maps.mergeInto(contents, nextKey, path.subList(1, path.size()), value, writer);
        } else {
            writer.accept(source, key, Maps.nestedMaps(path, value));
        }
    }

    private static Map<String, Object> nestedMaps(List<String> path, Object value) {
        HashMap<String, Object> root;
        HashMap<String, Object> m = root = new HashMap<String, Object>(1);
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            String key = path.get(i);
            if (i + 1 == size) {
                m.put(key, value);
                continue;
            }
            HashMap nextChild = new HashMap(1);
            m.put(key, nextChild);
            m = nextChild;
        }
        return root;
    }
}

