/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

public class MapComparator
implements Comparator<Map> {
    private static final MapComparator INSTANCE = new MapComparator();

    private MapComparator() {
    }

    public static MapComparator getInstance() {
        return INSTANCE;
    }

    public static <K, V> int compareMaps(Map<K, V> m1, Map<K, V> m2) {
        Objects.requireNonNull(m1, "map is null");
        Objects.requireNonNull(m2, "map is null");
        int sizeCompare = Integer.compare(m1.size(), m2.size());
        if (sizeCompare != 0) {
            return sizeCompare;
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            V thisValue = entry.getValue();
            V otherValue = m2.get(entry.getKey());
            if (thisValue == null) {
                if (otherValue == null) continue;
                return 1;
            }
            if (thisValue.equals(otherValue)) continue;
            if (otherValue == null) {
                return -1;
            }
            if (!thisValue.getClass().equals(otherValue.getClass())) {
                DataType<?> leftType = DataTypes.guessType(thisValue);
                int cmp = leftType.compare(thisValue, leftType.implicitCast(otherValue));
                if (cmp == 0) continue;
                return cmp;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int compare(Map o1, Map o2) {
        return MapComparator.compareMaps(o1, o2);
    }
}

