/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class Lists2 {
    private Lists2() {
    }

    public static <T> List<T> concat(Collection<? extends T> list1, Collection<? extends T> list2) {
        ArrayList<T> list = new ArrayList<T>(list1.size() + list2.size());
        list.addAll(list1);
        list.addAll(list2);
        return list;
    }

    public static <T> List<T> concat(Collection<? extends T> list1, T item) {
        ArrayList<T> xs = new ArrayList<T>(list1.size() + 1);
        xs.addAll(list1);
        xs.add(item);
        return xs;
    }

    public static <T> List<T> concatUnique(List<? extends T> list1, Collection<? extends T> list2) {
        ArrayList<T> result = new ArrayList<T>(list1.size() + list2.size());
        result.addAll(list1);
        for (T item : list2) {
            if (list1.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <I, O> List<O> map(Collection<I> list, Function<? super I, ? extends O> mapper) {
        if (list.isEmpty()) {
            return List.of();
        }
        ArrayList<O> copy = new ArrayList<O>(list.size());
        for (I item : list) {
            copy.add(mapper.apply(item));
        }
        return copy;
    }

    public static <I, O> List<O> mapLazy(List<I> list, Function<? super I, ? extends O> mapper) {
        return new LazyMapList<I, O>(list, mapper);
    }

    public static <T> List<T> mapIfChange(List<T> list, Function<? super T, ? extends T> mapper) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<T> copy = new ArrayList<T>(list.size());
        boolean changed = false;
        for (T item : list) {
            T mapped = mapper.apply(item);
            changed = changed || item != mapped;
            copy.add(mapped);
        }
        return changed ? copy : list;
    }

    public static <T> T getOnlyElement(List<T> items) {
        switch (items.size()) {
            case 0: {
                throw new NoSuchElementException("List is empty");
            }
            case 1: {
                return items.get(0);
            }
        }
        throw new IllegalArgumentException("Expected 1 element, got: " + items.size());
    }

    public static <O, I> List<O> mapTail(O head, List<I> tail, Function<I, O> mapper) {
        ArrayList<O> list = new ArrayList<O>(tail.size() + 1);
        list.add(head);
        for (I input : tail) {
            list.add(mapper.apply(input));
        }
        return list;
    }

    public static <T> int findFirstNonPeer(List<T> items, int begin, int end, @Nullable Comparator<T> cmp) {
        if (cmp == null || begin + 1 >= end) {
            return end;
        }
        T fst = items.get(begin);
        if (cmp.compare(fst, items.get(begin + 1)) != 0) {
            return begin + 1;
        }
        int low = begin + 1;
        int high = end;
        while (low <= high) {
            int mid = low + high >>> 1;
            T t = items.get(mid);
            int cmpResult = cmp.compare(fst, t);
            if (cmpResult == 0) {
                int next = mid + 1;
                if (next == high || cmp.compare(fst, items.get(next)) != 0) {
                    return next;
                }
                low = next;
                continue;
            }
            if (cmpResult < 0) {
                high = mid;
                continue;
            }
            low = mid;
        }
        return end;
    }

    public static <T> int findFirstPreviousPeer(List<T> items, int itemIdx, @Nullable Comparator<T> cmp) {
        if (cmp == null) {
            return 0;
        }
        int firstPeer = itemIdx;
        T item = items.get(itemIdx);
        int i = itemIdx - 1;
        while (i >= 0 && cmp.compare(item, items.get(i)) == 0) {
            firstPeer = i--;
        }
        return firstPeer;
    }

    public static <T> int findFirstLTEProbeValue(List<T> sortedItems, int upperBoundary, int itemIdx, T probe, Comparator<T> cmp) {
        int start = itemIdx;
        int end = upperBoundary - 1;
        int firstLTEProbeIdx = -1;
        while (start <= end) {
            int mid = start + end >>> 1;
            if (cmp.compare(sortedItems.get(mid), probe) > 0) {
                end = mid - 1;
                continue;
            }
            firstLTEProbeIdx = mid;
            start = mid + 1;
        }
        return firstLTEProbeIdx;
    }

    public static <T> int findFirstGTEProbeValue(List<T> sortedItems, int lowerBoundary, int itemIdx, T probe, Comparator<T> cmp) {
        int start = lowerBoundary;
        int end = itemIdx - 1;
        int firstGTEProbeIdx = -1;
        while (start <= end) {
            int mid = start + end >>> 1;
            if (cmp.compare(sortedItems.get(mid), probe) < 0) {
                start = mid + 1;
                continue;
            }
            firstGTEProbeIdx = mid;
            end = mid - 1;
        }
        return firstGTEProbeIdx;
    }

    public static <T> String joinOn(String delimiter, List<? extends T> items, Function<? super T, String> mapper) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (int i = 0; i < items.size(); ++i) {
            joiner.add(mapper.apply(items.get(i)));
        }
        return joiner.toString();
    }

    public static <T> String joinOn(String delimiter, Iterable<? extends T> items, Function<? super T, String> mapper) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (T item : items) {
            joiner.add(mapper.apply(item));
        }
        return joiner.toString();
    }

    static class LazyMapList<I, O>
    extends AbstractList<O>
    implements RandomAccess {
        private final List<I> list;
        private final Function<? super I, ? extends O> mapper;

        LazyMapList(List<I> list, Function<? super I, ? extends O> mapper) {
            this.list = list;
            this.mapper = mapper;
        }

        @Override
        public O get(int index) {
            return this.mapper.apply(this.list.get(index));
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

