/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public final class StringUtils {
    public static List<String> splitToList(char delim, String value) {
        ArrayList<String> result = new ArrayList<String>();
        int lastStart = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != delim) continue;
            result.add(value.substring(lastStart, i));
            lastStart = i + 1;
        }
        if (lastStart <= value.length()) {
            result.add(value.substring(lastStart));
        }
        return result;
    }

    @Nullable
    public static String nullOrString(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static boolean isBlank(String string, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (Character.isSpaceChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String padEnd(String s, int minimumLength, char c) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (s.length() >= minimumLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder(minimumLength);
        sb.append(s);
        for (int i = s.length(); i < minimumLength; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }
}

