/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common;

import java.util.Objects;

public final class MutableLong {
    private long value;
    private boolean hasValue = false;

    public MutableLong(long value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public long value() {
        return this.value;
    }

    public void setValue(long value) {
        this.hasValue = true;
        this.value = value;
    }

    public MutableLong add(long value) {
        this.setValue(this.value + value);
        return this;
    }

    public MutableLong sub(long value) {
        this.setValue(this.value - value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableLong that = (MutableLong)o;
        return this.value == that.value && this.hasValue == that.hasValue;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.hasValue);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

