/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common;

public final class Booleans {
    private Booleans() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static boolean parseBoolean(char[] text, int offset, int length, boolean defaultValue) {
        if (text == null || length == 0) {
            return defaultValue;
        }
        return Booleans.parseBoolean(new String(text, offset, length));
    }

    public static boolean isBoolean(char[] text, int offset, int length) {
        if (text == null || length == 0) {
            return false;
        }
        return Booleans.isBoolean(new String(text, offset, length));
    }

    public static boolean isBoolean(String value) {
        return Booleans.isFalse(value) || Booleans.isTrue(value);
    }

    public static boolean parseBoolean(String value) {
        if (Booleans.isFalse(value)) {
            return false;
        }
        if (Booleans.isTrue(value)) {
            return true;
        }
        throw new IllegalArgumentException("Failed to parse value [" + value + "] as only [true] or [false] are allowed.");
    }

    private static boolean hasText(CharSequence str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (Booleans.hasText(value)) {
            return Booleans.parseBoolean(value);
        }
        return defaultValue;
    }

    public static Boolean parseBoolean(String value, Boolean defaultValue) {
        if (Booleans.hasText(value)) {
            return Booleans.parseBoolean(value);
        }
        return defaultValue;
    }

    public static boolean isFalse(String value) {
        return "false".equals(value);
    }

    public static boolean isTrue(String value) {
        return "true".equals(value);
    }
}

