/*
 * Decompiled with CFR 0.152.
 */
package io.crate.cluster.gracefulstop;

import io.crate.action.FutureActionListener;
import io.crate.action.sql.SQLOperations;
import io.crate.cluster.gracefulstop.DataAvailability;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.common.collections.MapBuilder;
import io.crate.common.unit.TimeValue;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.execution.jobs.TasksService;
import io.crate.settings.CrateSetting;
import io.crate.types.DataTypes;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.TransportClusterHealthAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.admin.cluster.settings.TransportClusterUpdateSettingsAction;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

@Singleton
public class DecommissioningService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(DecommissioningService.class);
    static final String DECOMMISSION_PREFIX = "crate.internal.decommission.";
    public static final CrateSetting<Settings> DECOMMISSION_INTERNAL_SETTING_GROUP = CrateSetting.of(Setting.groupSetting("crate.internal.decommission.", Setting.Property.NodeScope, Setting.Property.Dynamic), DataTypes.UNTYPED_OBJECT);
    public static final CrateSetting<DataAvailability> GRACEFUL_STOP_MIN_AVAILABILITY_SETTING = CrateSetting.of(new Setting<DataAvailability>("cluster.graceful_stop.min_availability", DataAvailability.PRIMARIES.name(), DataAvailability::of, Setting.Property.Dynamic, Setting.Property.NodeScope), DataTypes.STRING);
    public static final CrateSetting<Boolean> GRACEFUL_STOP_FORCE_SETTING = CrateSetting.of(Setting.boolSetting("cluster.graceful_stop.force", false, Setting.Property.Dynamic, Setting.Property.NodeScope), DataTypes.BOOLEAN);
    public static final CrateSetting<TimeValue> GRACEFUL_STOP_TIMEOUT_SETTING = CrateSetting.of(Setting.positiveTimeSetting("cluster.graceful_stop.timeout", new TimeValue(0x6DDD00L), Setting.Property.Dynamic, Setting.Property.NodeScope), DataTypes.STRING);
    private final ClusterService clusterService;
    private final JobsLogs jobsLogs;
    private final ScheduledExecutorService executorService;
    private final SQLOperations sqlOperations;
    private final IntSupplier numActiveContexts;
    private final TransportClusterHealthAction healthAction;
    private final TransportClusterUpdateSettingsAction updateSettingsAction;
    private final Runnable safeExitAction;
    private TimeValue gracefulStopTimeout;
    private Boolean forceStop;
    private DataAvailability dataAvailability;

    @Inject
    public DecommissioningService(Settings settings, ClusterService clusterService, JobsLogs jobsLogs, SQLOperations sqlOperations, TasksService tasksService, TransportClusterHealthAction healthAction, TransportClusterUpdateSettingsAction updateSettingsAction) {
        this(settings, clusterService, jobsLogs, Executors.newSingleThreadScheduledExecutor(), sqlOperations, tasksService::numActive, null, healthAction, updateSettingsAction);
    }

    @VisibleForTesting
    protected DecommissioningService(Settings settings, ClusterService clusterService, JobsLogs jobsLogs, ScheduledExecutorService executorService, SQLOperations sqlOperations, IntSupplier numActiveContexts, @Nullable Runnable safeExitAction, TransportClusterHealthAction healthAction, TransportClusterUpdateSettingsAction updateSettingsAction) {
        this.clusterService = clusterService;
        this.jobsLogs = jobsLogs;
        this.sqlOperations = sqlOperations;
        this.numActiveContexts = numActiveContexts;
        this.healthAction = healthAction;
        this.updateSettingsAction = updateSettingsAction;
        this.safeExitAction = safeExitAction == null ? () -> executorService.schedule(this::exit, 5L, TimeUnit.SECONDS) : safeExitAction;
        this.gracefulStopTimeout = GRACEFUL_STOP_TIMEOUT_SETTING.setting().get(settings);
        this.forceStop = GRACEFUL_STOP_FORCE_SETTING.setting().get(settings);
        this.dataAvailability = GRACEFUL_STOP_MIN_AVAILABILITY_SETTING.setting().get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(GRACEFUL_STOP_TIMEOUT_SETTING.setting(), this::setGracefulStopTimeout);
        clusterSettings.addSettingsUpdateConsumer(GRACEFUL_STOP_FORCE_SETTING.setting(), this::setGracefulStopForce);
        clusterSettings.addSettingsUpdateConsumer(GRACEFUL_STOP_MIN_AVAILABILITY_SETTING.setting(), this::setDataAvailability);
        this.executorService = executorService;
    }

    private void removeRemovedNodes(ClusterChangedEvent event) {
        if (!event.localNodeMaster() || !event.nodesRemoved()) {
            return;
        }
        Map<String, Object> removedDecommissionedNodes = DecommissioningService.getRemovedDecommissionedNodes(event.nodesDelta(), event.state().metadata().transientSettings());
        if (removedDecommissionedNodes != null) {
            this.updateSettingsAction.execute(new ClusterUpdateSettingsRequest().transientSettings(removedDecommissionedNodes));
        }
    }

    @Nullable
    private static Map<String, Object> getRemovedDecommissionedNodes(DiscoveryNodes.Delta nodesDelta, Settings transientSettings) {
        HashMap<CallSite, Object> toRemove = null;
        for (DiscoveryNode discoveryNode : nodesDelta.removedNodes()) {
            String nodeId;
            Settings decommissionSettings = DECOMMISSION_INTERNAL_SETTING_GROUP.setting().get(transientSettings);
            if (!decommissionSettings.hasValue(nodeId = discoveryNode.getId())) continue;
            if (toRemove == null) {
                toRemove = new HashMap<CallSite, Object>();
            }
            toRemove.put((CallSite)((Object)(DECOMMISSION_PREFIX + nodeId)), null);
        }
        return toRemove;
    }

    @Override
    protected void doStart() {
        this.clusterService.addListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        this.removeRemovedNodes(event);
    }

    public CompletableFuture<Void> decommission() {
        this.sqlOperations.disable();
        return ((CompletableFuture)((CompletableFuture)this.clusterSetDecommissionNodeSetting().exceptionally(e -> {
            LOGGER.error("Couldn't set settings. Graceful shutdown failed", e);
            throw new IllegalStateException("Graceful shutdown failed", (Throwable)e);
        })).thenCompose(r -> this.clusterHealthGet())).handle((res, error) -> {
            if (error == null) {
                long startTime = System.nanoTime();
                this.executorService.submit(() -> this.exitIfNoActiveRequests(startTime));
            } else {
                this.executorService.submit(() -> this.forceStopOrAbort((Throwable)error));
            }
            return null;
        });
    }

    void forceStopOrAbort(@Nullable Throwable e) {
        if (this.forceStop.booleanValue()) {
            this.exit();
        } else {
            LOGGER.warn("Aborting graceful shutdown due to error", e);
            this.removeDecommissioningSetting();
            this.sqlOperations.enable();
        }
    }

    void exitIfNoActiveRequests(long startTime) {
        if (this.jobsLogs.activeRequests() == 0L && this.numActiveContexts.getAsInt() == 0) {
            this.safeExitAction.run();
            return;
        }
        if (System.nanoTime() - startTime > this.gracefulStopTimeout.nanos()) {
            this.forceStopOrAbort(new TimeoutException("gracefulStopTimeout reached - waited too long for pending requests to finish"));
            return;
        }
        LOGGER.info("There are still active requests on this node, delaying graceful shutdown");
        this.executorService.schedule(() -> this.exitIfNoActiveRequests(startTime), 5L, TimeUnit.SECONDS);
    }

    private CompletableFuture<ClusterUpdateSettingsResponse> clusterSetDecommissionNodeSetting() {
        if (this.dataAvailability == DataAvailability.NONE) {
            return CompletableFuture.completedFuture(null);
        }
        Settings settings = Settings.builder().put(DECOMMISSION_PREFIX + this.clusterService.localNode().getId(), true).build();
        FutureActionListener settingsResponseFutureListener = FutureActionListener.newInstance();
        this.updateSettingsAction.execute(new ClusterUpdateSettingsRequest().transientSettings(settings), settingsResponseFutureListener);
        return settingsResponseFutureListener;
    }

    private CompletableFuture<ClusterHealthResponse> clusterHealthGet() {
        if (this.dataAvailability == DataAvailability.NONE) {
            return CompletableFuture.completedFuture(null);
        }
        ClusterHealthRequest request = new ClusterHealthRequest().waitForNoRelocatingShards(true).waitForEvents(Priority.LANGUID).timeout(this.gracefulStopTimeout);
        request = this.dataAvailability == DataAvailability.FULL ? request.waitForGreenStatus() : request.waitForYellowStatus();
        FutureActionListener listener = FutureActionListener.newInstance();
        this.healthAction.execute(request, listener);
        return listener;
    }

    void exit() {
        System.exit(0);
    }

    @VisibleForTesting
    protected void removeDecommissioningSetting() {
        if (this.dataAvailability == DataAvailability.NONE) {
            return;
        }
        Map<CallSite, Object> settingsToRemove = MapBuilder.newMapBuilder().put((CallSite)((Object)(DECOMMISSION_PREFIX + this.clusterService.localNode().getId())), null).map();
        this.updateSettingsAction.execute(new ClusterUpdateSettingsRequest().transientSettings(settingsToRemove));
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() {
        this.executorService.shutdownNow();
    }

    private void setGracefulStopTimeout(TimeValue gracefulStopTimeout) {
        this.gracefulStopTimeout = gracefulStopTimeout;
    }

    private void setGracefulStopForce(boolean forceStop) {
        this.forceStop = forceStop;
    }

    private void setDataAvailability(DataAvailability dataAvailability) {
        this.dataAvailability = dataAvailability;
    }
}

