/*
 * Decompiled with CFR 0.152.
 */
package io.crate.cluster.gracefulstop;

import com.google.common.collect.ImmutableSet;
import io.crate.cluster.gracefulstop.DataAvailability;
import io.crate.cluster.gracefulstop.DecommissioningService;
import java.util.Set;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;

public class DecommissionAllocationDecider
extends AllocationDecider {
    public static final String NAME = "decommission";
    private Set<String> decommissioningNodes = ImmutableSet.of();
    private DataAvailability dataAvailability;

    public DecommissionAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.updateDecommissioningNodes(DecommissioningService.DECOMMISSION_INTERNAL_SETTING_GROUP.setting().get(settings));
        this.dataAvailability = DecommissioningService.GRACEFUL_STOP_MIN_AVAILABILITY_SETTING.setting().get(settings);
        clusterSettings.addSettingsUpdateConsumer(DecommissioningService.DECOMMISSION_INTERNAL_SETTING_GROUP.setting(), this::updateDecommissioningNodes);
        clusterSettings.addSettingsUpdateConsumer(DecommissioningService.GRACEFUL_STOP_MIN_AVAILABILITY_SETTING.setting(), this::updateMinAvailability);
    }

    private void updateDecommissioningNodes(Settings decommissionNodesSettings) {
        this.decommissioningNodes = decommissionNodesSettings.keySet();
    }

    private void updateMinAvailability(DataAvailability availability) {
        this.dataAvailability = availability;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (this.decommissioningNodes.contains(node.nodeId()) && this.dataAvailability == DataAvailability.PRIMARIES && !shardRouting.primary()) {
            return allocation.decision(Decision.NO, NAME, "dataAvailability=primaries, shard=replica, decommissioned=true", new Object[0]);
        }
        return this.canRemainOrAllocate(node.nodeId(), shardRouting, allocation);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canRemainOrAllocate(node.nodeId(), shardRouting, allocation);
    }

    private Decision canRemainOrAllocate(String nodeId, ShardRouting shardRouting, RoutingAllocation allocation) {
        if (this.dataAvailability == DataAvailability.NONE) {
            return allocation.decision(Decision.YES, NAME, "dataAvailability=none", new Object[0]);
        }
        if (this.decommissioningNodes.contains(nodeId)) {
            if (this.dataAvailability == DataAvailability.PRIMARIES && !shardRouting.primary()) {
                return allocation.decision(Decision.YES, NAME, "dataAvailability=primaries shard=replica decommissioned=true", new Object[0]);
            }
            return allocation.decision(Decision.NO, NAME, "node is being decommissioned", new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, "node isn't decommissioned", new Object[0]);
    }
}

