/*
 * Decompiled with CFR 0.152.
 */
package io.crate.cluster.decommission;

import io.crate.cluster.decommission.DecommissionNodeRequest;
import io.crate.cluster.gracefulstop.DecommissioningService;
import io.crate.execution.support.NodeAction;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.Transports;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportDecommissionNodeAction
implements NodeAction<DecommissionNodeRequest, AcknowledgedResponse> {
    private static final String ACTION_NAME = "internal:crate:sql/decommission/node";
    private static final String EXECUTOR = "management";
    private final DecommissioningService decommissioningService;
    private final Transports transports;

    @Inject
    public TransportDecommissionNodeAction(TransportService transportService, DecommissioningService decommissioningService, Transports transports) {
        this.decommissioningService = decommissioningService;
        this.transports = transports;
        transportService.registerRequestHandler(ACTION_NAME, EXECUTOR, DecommissionNodeRequest::new, new NodeActionRequestHandler<DecommissionNodeRequest, AcknowledgedResponse>(this));
    }

    public void execute(String nodeId, DecommissionNodeRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.transports.sendRequest(ACTION_NAME, nodeId, request, listener, new ActionListenerResponseHandler<AcknowledgedResponse>(listener, AcknowledgedResponse::new));
    }

    @Override
    public CompletableFuture<AcknowledgedResponse> nodeOperation(DecommissionNodeRequest request) {
        try {
            return this.decommissioningService.decommission().thenApply(aVoid -> new AcknowledgedResponse(true));
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }
}

