/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.SizeEstimator;
import javax.annotation.Nullable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

public final class StringSizeEstimator
extends SizeEstimator<String> {
    public static final StringSizeEstimator INSTANCE = new StringSizeEstimator();
    private static final long BASE_BYTES_PER_BYTES_REF = RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 3L;

    private StringSizeEstimator() {
    }

    public static long estimate(@Nullable String value) {
        return RamUsageEstimator.sizeOf((String)value);
    }

    @Override
    public long estimateSize(@Nullable String value) {
        return RamUsageEstimator.sizeOf((String)value);
    }

    public static long estimateSize(@Nullable BytesRef value) {
        if (value == null) {
            return 8L;
        }
        return RamUsageEstimator.alignObjectSize((long)(BASE_BYTES_PER_BYTES_REF + (long)value.length));
    }
}

