/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.ArraySizeEstimator;
import io.crate.breaker.ConstSizeEstimator;
import io.crate.breaker.MapSizeEstimator;
import io.crate.breaker.NumericSizeEstimator;
import io.crate.breaker.RecordSizeEstimator;
import io.crate.breaker.RegprocSizeEstimator;
import io.crate.breaker.SamplingSizeEstimator;
import io.crate.breaker.SizeEstimator;
import io.crate.breaker.StringSizeEstimator;
import io.crate.common.collections.Lists2;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.FixedWidthType;
import io.crate.types.RowType;
import java.util.Locale;

public class SizeEstimatorFactory {
    private static final int SAMPLE_EVERY_NTH = 100;

    public static <T> SizeEstimator<T> create(DataType<?> type) {
        switch (type.id()) {
            case 0: {
                return new ConstSizeEstimator(256L);
            }
            case 12: 
            case 14: {
                return new SamplingSizeEstimator(100, MapSizeEstimator.INSTANCE);
            }
            case 4: 
            case 5: {
                return StringSizeEstimator.INSTANCE;
            }
            case 100: {
                SizeEstimator<T> innerEstimator = SizeEstimatorFactory.create(((ArrayType)type).innerType());
                return ArraySizeEstimator.create(innerEstimator);
            }
            case 21: {
                return ArraySizeEstimator.create(SizeEstimatorFactory.create(DataTypes.INTEGER));
            }
            case 18: {
                return new RecordSizeEstimator(Lists2.map(((RowType)type).fieldTypes(), SizeEstimatorFactory::create));
            }
            case 19: {
                return RegprocSizeEstimator.INSTANCE;
            }
            case 22: {
                return NumericSizeEstimator.INSTANCE;
            }
        }
        if (type instanceof FixedWidthType) {
            return new ConstSizeEstimator(((FixedWidthType)((Object)type)).fixedSize());
        }
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot get SizeEstimator for type %s", type));
    }
}

