/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.RamAccounting;
import io.crate.breaker.RowAccounting;
import io.crate.breaker.SizeEstimator;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Collection;

public class RowCellsAccountingWithEstimators
implements RowAccounting<Object[]> {
    private final RamAccounting ramAccounting;
    private final ArrayList<SizeEstimator<Object>> estimators;
    private final int extraSizePerRow;

    public RowCellsAccountingWithEstimators(Collection<? extends DataType> columnTypes, RamAccounting ramAccounting, int extraSizePerRow) {
        this.estimators = new ArrayList(columnTypes.size());
        for (DataType dataType : columnTypes) {
            this.estimators.add(SizeEstimatorFactory.create(dataType));
        }
        this.ramAccounting = ramAccounting;
        this.extraSizePerRow = extraSizePerRow;
    }

    @Override
    public void accountForAndMaybeBreak(Object[] rowCells) {
        assert (rowCells.length == this.estimators.size()) : "Size of row must match the number of estimators";
        long size = 0L;
        for (int i = 0; i < rowCells.length; ++i) {
            size += this.estimators.get(i).estimateSize(rowCells[i]) + (long)this.extraSizePerRow;
        }
        this.ramAccounting.addBytes(size);
    }

    @Override
    public void release() {
        this.ramAccounting.release();
    }
}

