/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.EstimateRowSize;
import io.crate.breaker.RamAccounting;
import io.crate.breaker.RowAccounting;
import io.crate.data.Row;
import io.crate.types.DataType;
import java.util.Collection;

public class RowAccountingWithEstimators
implements RowAccounting<Row> {
    private final RamAccounting ramAccounting;
    private final EstimateRowSize estimateRowSize;
    private int extraSizePerRow = 0;

    public RowAccountingWithEstimators(Collection<? extends DataType> columnTypes, RamAccounting ramAccounting) {
        this.estimateRowSize = new EstimateRowSize(columnTypes);
        this.ramAccounting = ramAccounting;
    }

    public RowAccountingWithEstimators(Collection<? extends DataType> columnTypes, RamAccounting ramAccounting, int extraSizePerRow) {
        this(columnTypes, ramAccounting);
        this.extraSizePerRow = extraSizePerRow;
    }

    @Override
    public void accountForAndMaybeBreak(Row row) {
        this.ramAccounting.addBytes(this.estimateRowSize.applyAsLong(row) + (long)this.extraSizePerRow);
    }

    @Override
    public void release() {
        this.ramAccounting.release();
    }
}

