/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.SizeEstimator;
import io.crate.data.Row;
import java.util.List;
import javax.annotation.Nullable;

public final class RecordSizeEstimator
extends SizeEstimator<Row> {
    private final List<SizeEstimator<? super Object>> fieldEstimators;

    public RecordSizeEstimator(List<SizeEstimator<? super Object>> fieldEstimators) {
        this.fieldEstimators = fieldEstimators;
    }

    @Override
    public long estimateSize(@Nullable Row value) {
        if (value == null) {
            return 8L;
        }
        assert (this.fieldEstimators.size() == value.numColumns()) : "The row must have the same number of fields as `fieldEstimators` are available";
        long size = 0L;
        for (int i = 0; i < value.numColumns(); ++i) {
            size += this.fieldEstimators.get(i).estimateSize(value.get(i));
        }
        return size;
    }
}

