/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.SizeEstimator;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class MultiSizeEstimator
extends SizeEstimator<List<Object>> {
    private final List<SizeEstimator<Object>> subEstimators;

    public MultiSizeEstimator(List<? extends DataType> keyTypes) {
        this.subEstimators = new ArrayList<SizeEstimator<Object>>(keyTypes.size());
        for (DataType dataType : keyTypes) {
            this.subEstimators.add(SizeEstimatorFactory.create(dataType));
        }
    }

    @Override
    public long estimateSize(@Nullable List<Object> value) {
        assert (value != null && value.size() == this.subEstimators.size()) : "value must have the same number of items as there are keyTypes/sizeEstimators";
        long size = 0L;
        for (int i = 0; i < value.size(); ++i) {
            size += this.subEstimators.get(i).estimateSize(value.get(i));
        }
        return size;
    }
}

