/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.SizeEstimator;
import io.crate.breaker.SizeEstimatorFactory;
import io.crate.data.Row;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.function.ToLongFunction;

public final class EstimateRowSize
implements ToLongFunction<Row> {
    private final ArrayList<SizeEstimator<Object>> estimators;

    public EstimateRowSize(Collection<? extends DataType> columnTypes) {
        this.estimators = new ArrayList(columnTypes.size());
        for (DataType dataType : columnTypes) {
            this.estimators.add(SizeEstimatorFactory.create(dataType));
        }
    }

    @Override
    public long applyAsLong(Row row) {
        assert (row.numColumns() == this.estimators.size()) : String.format(Locale.ENGLISH, "row.numColumns=%d estimators.size=%d - the number must match. ", row.numColumns(), this.estimators.size());
        long size = 0L;
        for (int i = 0; i < row.numColumns(); ++i) {
            size += this.estimators.get(i).estimateSize(row.get(i));
        }
        return size;
    }
}

