/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.RamAccounting;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import javax.annotation.concurrent.ThreadSafe;
import org.elasticsearch.common.breaker.CircuitBreaker;

@ThreadSafe
public final class ConcurrentRamAccounting
implements RamAccounting {
    private final AtomicLong usedBytes = new AtomicLong(0L);
    private final LongConsumer reserveBytes;
    private final LongConsumer releaseBytes;

    public static ConcurrentRamAccounting forCircuitBreaker(String label, CircuitBreaker circuitBreaker) {
        return new ConcurrentRamAccounting(bytes -> circuitBreaker.addEstimateBytesAndMaybeBreak(bytes, label), bytes -> circuitBreaker.addWithoutBreaking(-bytes));
    }

    public ConcurrentRamAccounting(LongConsumer reserveBytes, LongConsumer releaseBytes) {
        this.reserveBytes = reserveBytes;
        this.releaseBytes = releaseBytes;
    }

    @Override
    public void addBytes(long bytes) {
        this.reserveBytes.accept(bytes);
        this.usedBytes.addAndGet(bytes);
    }

    @Override
    public long totalBytes() {
        return this.usedBytes.get();
    }

    @Override
    public void release() {
        long prevUsedBytes = this.usedBytes.getAndSet(0L);
        this.releaseBytes.accept(prevUsedBytes);
    }

    @Override
    public void close() {
        this.release();
    }
}

