/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.ConstSizeEstimator;
import io.crate.breaker.SizeEstimator;
import java.util.List;
import javax.annotation.Nullable;

public final class ArraySizeEstimator {
    public static <T> SizeEstimator<List<T>> create(SizeEstimator<T> elementEstimator) {
        if (elementEstimator instanceof ConstSizeEstimator) {
            long elementSize = ((ConstSizeEstimator)elementEstimator).size();
            return new ConstElementArraySizeEstimator(elementSize);
        }
        return new DynamicArraySizeEstimator<T>(elementEstimator);
    }

    private static class ConstElementArraySizeEstimator<T>
    extends SizeEstimator<List<T>> {
        private final long elementSize;

        ConstElementArraySizeEstimator(long elementSize) {
            this.elementSize = elementSize;
        }

        @Override
        public long estimateSize(@Nullable List<T> values) {
            if (values == null) {
                return 8L;
            }
            return 16L + (long)values.size() * this.elementSize;
        }
    }

    private static class DynamicArraySizeEstimator<T>
    extends SizeEstimator<List<T>> {
        private final SizeEstimator<T> elementEstimator;

        DynamicArraySizeEstimator(SizeEstimator<T> elementEstimator) {
            this.elementEstimator = elementEstimator;
        }

        @Override
        public long estimateSize(@Nullable List<T> values) {
            if (values == null) {
                return 8L;
            }
            long size = 16L;
            for (T val : values) {
                size += this.elementEstimator.estimateSize(val);
            }
            return size;
        }
    }
}

