/*
 * Decompiled with CFR 0.152.
 */
package io.crate.bootstrap;

import io.crate.bootstrap.BootstrapException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapProxy;
import org.elasticsearch.bootstrap.StartupExceptionProxy;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.NodeNames;
import org.elasticsearch.node.NodeValidationException;

public class CrateDB
extends EnvironmentAwareCommand {
    private final OptionSpecBuilder versionOption;
    private final OptionSpecBuilder daemonizeOption;
    private final OptionSpec<Path> pidfileOption;
    private final OptionSpecBuilder quietOption;

    private CrateDB() {
        super("starts CrateDB", "C", () -> {});
        this.versionOption = this.parser.acceptsAll(Arrays.asList("V", "version"), "Prints CrateDB version information and exits");
        this.daemonizeOption = this.parser.acceptsAll(Arrays.asList("d", "daemonize"), "Starts CrateDB in the background").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]);
        this.pidfileOption = this.parser.acceptsAll(Arrays.asList("p", "pidfile"), "Creates a pid file in the specified path on start").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        this.quietOption = this.parser.acceptsAll(Arrays.asList("q", "quiet"), "Turns off standard output/error streams logging in console").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).availableUnless((OptionSpec)this.daemonizeOption, new OptionSpec[0]);
    }

    public static void main(String[] args) throws Exception {
        LogConfigurator.registerErrorListener();
        CrateDB crate = new CrateDB();
        int status = CrateDB.main(args, crate, Terminal.DEFAULT);
        if (status != 0) {
            CrateDB.exit(status);
        }
    }

    private static int main(String[] args, CrateDB crateDb, Terminal terminal) throws Exception {
        return crateDb.main(args, terminal);
    }

    @Override
    protected Environment createEnv(Map<String, String> cmdLineSettings) throws UserException {
        String crateHomePath = cmdLineSettings.get("path.home");
        if (crateHomePath == null) {
            throw new IllegalArgumentException("Please set the environment variable CRATE_HOME or use -Cpath.home on the command-line.");
        }
        String confPathCLI = cmdLineSettings.remove("path.conf");
        Path confPath = confPathCLI != null ? Paths.get(confPathCLI, new String[0]) : Paths.get(crateHomePath, "config");
        return InternalSettingsPreparer.prepareEnvironment(Settings.EMPTY, cmdLineSettings, confPath, NodeNames::randomNodeName);
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new UserException(64, "Positional arguments not allowed, found " + options.nonOptionArguments());
        }
        if (options.has((OptionSpec)this.versionOption)) {
            if (options.has((OptionSpec)this.daemonizeOption) || options.has(this.pidfileOption)) {
                throw new UserException(64, "CrateDB version option is mutually exclusive with any other option");
            }
            terminal.println("Version: " + Version.CURRENT + ", Build: " + Build.CURRENT.hashShort() + "/" + Build.CURRENT.timestamp() + ", JVM: " + JvmInfo.jvmInfo().version());
            return;
        }
        boolean daemonize = options.has((OptionSpec)this.daemonizeOption);
        Path pidFile = (Path)this.pidfileOption.value(options);
        env = CrateDB.addPidFileSetting(pidFile, env);
        boolean quiet = options.has((OptionSpec)this.quietOption);
        try {
            this.init(daemonize, quiet, env);
        }
        catch (NodeValidationException e) {
            throw new UserException(78, e.getMessage());
        }
    }

    private static Environment addPidFileSetting(Path pidFile, Environment existingEnv) {
        if (pidFile == null) {
            return existingEnv;
        }
        Settings settingsWithPid = Settings.builder().put(existingEnv.settings()).put(Environment.PIDFILE_SETTING.getKey(), pidFile).build();
        return new Environment(settingsWithPid, existingEnv.configFile());
    }

    private void init(boolean daemonize, boolean quiet, Environment env) throws NodeValidationException, UserException {
        try {
            BootstrapProxy.init(!daemonize, quiet, env);
        }
        catch (BootstrapException | RuntimeException e) {
            throw new StartupExceptionProxy(e);
        }
    }

    static void close(String[] args) throws IOException {
        BootstrapProxy.stop();
    }
}

