/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.v2;

import io.crate.action.FutureActionListener;
import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;

@Singleton
public class BlobAdminClient {
    private final TransportCreateIndexAction createIndexAction;
    private final TransportDeleteIndexAction deleteIndexAction;

    @Inject
    public BlobAdminClient(TransportCreateIndexAction createIndexAction, TransportDeleteIndexAction deleteIndexAction) {
        this.createIndexAction = createIndexAction;
        this.deleteIndexAction = deleteIndexAction;
    }

    public CompletableFuture<Long> createBlobTable(String tableName, Settings indexSettings) {
        Settings.Builder builder = Settings.builder();
        builder.put(indexSettings);
        builder.put(BlobIndicesService.SETTING_INDEX_BLOBS_ENABLED.getKey(), true);
        FutureActionListener<CreateIndexResponse, Long> listener = new FutureActionListener<CreateIndexResponse, Long>(r -> 1L);
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(BlobIndex.fullIndexName(tableName), builder.build());
        this.createIndexAction.execute(createIndexRequest, listener);
        return listener;
    }

    public CompletableFuture<Long> dropBlobTable(String tableName) {
        FutureActionListener<AcknowledgedResponse, Long> listener = new FutureActionListener<AcknowledgedResponse, Long>(r -> 1L);
        this.deleteIndexAction.execute(new DeleteIndexRequest(BlobIndex.fullIndexName(tableName)), listener);
        return listener;
    }
}

