/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.transfer;

import java.io.IOException;
import java.util.UUID;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class PutBlobHeadChunkRequest
extends TransportRequest {
    public final UUID transferId;
    public final BytesReference content;

    public PutBlobHeadChunkRequest(UUID transferId, BytesArray bytesArray) {
        this.transferId = transferId;
        this.content = bytesArray;
    }

    public PutBlobHeadChunkRequest(StreamInput in) throws IOException {
        super(in);
        this.transferId = new UUID(in.readLong(), in.readLong());
        this.content = in.readBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.transferId.getMostSignificantBits());
        out.writeLong(this.transferId.getLeastSignificantBits());
        out.writeBytesReference(this.content);
    }
}

