/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.transfer;

import io.crate.blob.BlobTransferStatus;
import io.crate.blob.BlobTransferTarget;
import io.crate.blob.transfer.BlobInfoRequest;
import io.crate.blob.transfer.BlobTransferInfoResponse;
import io.crate.blob.transfer.GetBlobHeadRequest;
import io.crate.blob.transfer.PutBlobHeadChunkRequest;
import io.crate.blob.transfer.PutHeadChunkRunnable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class BlobHeadRequestHandler {
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final BlobTransferTarget blobTransferTarget;
    private final ClusterService clusterService;

    @Inject
    public BlobHeadRequestHandler(TransportService transportService, ClusterService clusterService, BlobTransferTarget blobTransferTarget, ThreadPool threadPool) {
        this.blobTransferTarget = blobTransferTarget;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.threadPool = threadPool;
    }

    public void registerHandler() {
        this.transportService.registerRequestHandler("internal:crate:blob/shard/tmp_transfer/get_head", "generic", GetBlobHeadRequest::new, new GetBlobHeadHandler());
        this.transportService.registerRequestHandler("internal:crate:blob/shard/tmp_transfer/get_info", "generic", BlobInfoRequest::new, new GetTransferInfoHandler());
        this.transportService.registerRequestHandler("internal:crate:blob/shard/tmp_transfer/put_head_chunk", "generic", PutBlobHeadChunkRequest::new, new PutBlobHeadChunkHandler());
    }

    public static class Actions {
        public static final String GET_BLOB_HEAD = "internal:crate:blob/shard/tmp_transfer/get_head";
        public static final String GET_TRANSFER_INFO = "internal:crate:blob/shard/tmp_transfer/get_info";
        public static final String PUT_BLOB_HEAD_CHUNK = "internal:crate:blob/shard/tmp_transfer/put_head_chunk";
    }

    private class GetBlobHeadHandler
    implements TransportRequestHandler<GetBlobHeadRequest> {
        private GetBlobHeadHandler() {
        }

        @Override
        public void messageReceived(GetBlobHeadRequest request, TransportChannel channel, Task task) throws Exception {
            BlobTransferStatus transferStatus = BlobHeadRequestHandler.this.blobTransferTarget.getActiveTransfer(request.transferId);
            assert (transferStatus != null) : "Received GetBlobHeadRequest for transfer" + request.transferId.toString() + "but don't have an activeTransfer with that id";
            DiscoveryNode recipientNode = BlobHeadRequestHandler.this.clusterService.state().getNodes().get(request.senderNodeId);
            long bytesToSend = request.endPos;
            BlobHeadRequestHandler.this.blobTransferTarget.gotAGetBlobHeadRequest(request.transferId);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
            BlobHeadRequestHandler.this.threadPool.generic().execute(new PutHeadChunkRunnable(transferStatus.digestBlob(), bytesToSend, BlobHeadRequestHandler.this.transportService, BlobHeadRequestHandler.this.blobTransferTarget, recipientNode, request.transferId));
        }
    }

    private class GetTransferInfoHandler
    implements TransportRequestHandler<BlobInfoRequest> {
        private GetTransferInfoHandler() {
        }

        @Override
        public void messageReceived(BlobInfoRequest request, TransportChannel channel, Task task) throws Exception {
            BlobTransferStatus transferStatus = BlobHeadRequestHandler.this.blobTransferTarget.getActiveTransfer(request.transferId);
            assert (transferStatus != null) : "Received GetBlobHeadRequest for transfer " + request.transferId.toString() + " but don't have an activeTransfer with that id";
            BlobTransferInfoResponse response = new BlobTransferInfoResponse(transferStatus.index(), transferStatus.digestBlob().getDigest());
            channel.sendResponse(response);
        }
    }

    private class PutBlobHeadChunkHandler
    implements TransportRequestHandler<PutBlobHeadChunkRequest> {
        private PutBlobHeadChunkHandler() {
        }

        @Override
        public void messageReceived(PutBlobHeadChunkRequest request, TransportChannel channel, Task task) throws Exception {
            BlobTransferStatus transferStatus = BlobHeadRequestHandler.this.blobTransferTarget.getActiveTransfer(request.transferId);
            assert (transferStatus != null) : "transferStatus should not be null";
            transferStatus.digestBlob().addToHead(request.content);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }
}

