/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.DeleteBlobRequest;
import io.crate.blob.DeleteBlobResponse;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.blob.v2.BlobShard;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteBlobAction
extends TransportReplicationAction<DeleteBlobRequest, DeleteBlobRequest, DeleteBlobResponse> {
    private final BlobIndicesService blobIndicesService;

    @Inject
    public TransportDeleteBlobAction(TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, BlobIndicesService blobIndicesService) {
        super("internal:crate:blob/delete_blob", transportService, clusterService, indicesService, threadPool, shardStateAction, DeleteBlobRequest::new, DeleteBlobRequest::new, "write");
        this.blobIndicesService = blobIndicesService;
        this.logger.trace("Constructor");
    }

    @Override
    protected DeleteBlobResponse newResponseInstance(StreamInput in) throws IOException {
        return new DeleteBlobResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(DeleteBlobRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<DeleteBlobRequest, DeleteBlobResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            this.logger.trace("shardOperationOnPrimary {}", (Object)shardRequest);
            BlobShard blobShard = this.blobIndicesService.blobShardSafe(shardRequest.shardId());
            boolean deleted = blobShard.delete(shardRequest.id());
            DeleteBlobResponse response = new DeleteBlobResponse(deleted);
            return new TransportReplicationAction.PrimaryResult<DeleteBlobRequest, DeleteBlobResponse>(shardRequest, response);
        });
    }

    @Override
    protected TransportReplicationAction.ReplicaResult shardOperationOnReplica(DeleteBlobRequest request, IndexShard replica) {
        this.logger.warn("shardOperationOnReplica operating on replica but relocation is not implemented {}", (Object)request);
        BlobShard blobShard = this.blobIndicesService.blobShardSafe(request.shardId());
        blobShard.delete(request.id());
        return new TransportReplicationAction.ReplicaResult();
    }
}

