/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.BlobTransferRequest;
import io.crate.common.Hex;
import java.io.IOException;
import java.util.UUID;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class StartBlobRequest
extends BlobTransferRequest<StartBlobRequest> {
    private byte[] digest;

    public StartBlobRequest(ShardId shardId, byte[] digest, BytesReference content, boolean last) {
        super(shardId, UUID.randomUUID(), content, last);
        this.digest = digest;
    }

    public String id() {
        return Hex.encodeHexString(this.digest);
    }

    public StartBlobRequest() {
    }

    public StartBlobRequest(StreamInput in) throws IOException {
        super(in);
        this.digest = new byte[20];
        in.read(this.digest);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.write(this.digest);
    }
}

