/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.BlobTransferRequest;
import io.crate.blob.IPutChunkRequest;
import io.crate.common.Hex;
import java.io.IOException;
import java.util.UUID;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class PutChunkRequest
extends BlobTransferRequest<PutChunkRequest>
implements IPutChunkRequest {
    private byte[] digest;
    private long currentPos;

    public PutChunkRequest(ShardId shardId, byte[] digest, UUID transferId, BytesReference content, long currentPos, boolean last) {
        super(shardId, transferId, content, last);
        this.digest = digest;
        this.currentPos = currentPos;
    }

    public PutChunkRequest() {
    }

    public String digest() {
        return Hex.encodeHexString(this.digest);
    }

    public long currentPos() {
        return this.currentPos;
    }

    public PutChunkRequest(StreamInput in) throws IOException {
        super(in);
        this.digest = new byte[20];
        in.read(this.digest);
        this.currentPos = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.write(this.digest);
        out.writeVLong(this.currentPos);
    }
}

