/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.IPutChunkRequest;
import java.io.IOException;
import java.util.UUID;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class PutChunkReplicaRequest
extends ReplicationRequest<PutChunkReplicaRequest>
implements IPutChunkRequest {
    public final String sourceNodeId;
    public final UUID transferId;
    public final long currentPos;
    public final BytesReference content;
    public final boolean isLast;

    public PutChunkReplicaRequest(ShardId shardId, String sourceNodeId, UUID transferId, long currentPos, BytesReference content, boolean isLast) {
        super(shardId);
        this.sourceNodeId = sourceNodeId;
        this.transferId = transferId;
        this.currentPos = currentPos;
        this.content = content;
        this.isLast = isLast;
    }

    public PutChunkReplicaRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNodeId = in.readString();
        this.transferId = new UUID(in.readLong(), in.readLong());
        this.currentPos = in.readVInt();
        this.content = in.readBytesReference();
        this.isLast = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.sourceNodeId);
        out.writeLong(this.transferId.getMostSignificantBits());
        out.writeLong(this.transferId.getLeastSignificantBits());
        out.writeVLong(this.currentPos);
        out.writeBytesReference(this.content);
        out.writeBoolean(this.isLast);
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public UUID transferId() {
        return this.transferId;
    }

    @Override
    public boolean isLast() {
        return this.isLast;
    }

    @Override
    public String toString() {
        return "PutChunkReplicaRequest{sourceNodeId='" + this.sourceNodeId + "', transferId=" + this.transferId + ", currentPos=" + this.currentPos + ", isLast=" + this.isLast + "}";
    }
}

