/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.common.Hex;
import java.io.IOException;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class DeleteBlobRequest
extends ReplicationRequest<DeleteBlobRequest> {
    private byte[] digest;

    public DeleteBlobRequest(ShardId shardId, byte[] digest) {
        super(shardId);
        this.digest = digest;
    }

    public DeleteBlobRequest() {
    }

    public DeleteBlobRequest(StreamInput in) throws IOException {
        super(in);
        this.digest = new byte[20];
        in.read(this.digest);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.write(this.digest);
    }

    public String id() {
        return Hex.encodeHexString(this.digest);
    }

    @Override
    public String toString() {
        return "DeleteBlobRequest{digest=" + this.id() + "}";
    }
}

