/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.IPutChunkRequest;
import java.io.IOException;
import java.util.UUID;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public abstract class BlobTransferRequest<T extends ReplicationRequest<T>>
extends ReplicationRequest<T>
implements IPutChunkRequest {
    private boolean last;
    private UUID transferId;
    private BytesReference content;

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    public BlobTransferRequest(ShardId shardId, UUID transferId, BytesReference content, boolean last) {
        super(shardId);
        this.transferId = transferId;
        this.content = content;
        this.last = last;
    }

    public BlobTransferRequest() {
    }

    public BlobTransferRequest(StreamInput in) throws IOException {
        super(in);
        this.transferId = new UUID(in.readLong(), in.readLong());
        this.content = in.readBytesReference();
        this.last = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.transferId.getMostSignificantBits());
        out.writeLong(this.transferId.getLeastSignificantBits());
        out.writeBytesReference(this.content);
        out.writeBoolean(this.last);
    }

    @Override
    public UUID transferId() {
        return this.transferId;
    }

    @Override
    public String toString() {
        return "BlobTransferRequest{last=" + this.last + ", transferId=" + this.transferId + "}";
    }
}

