/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.BlobTransferTarget;
import io.crate.blob.RemoteDigestBlob;
import io.crate.blob.exceptions.MissingHTTPEndpointException;
import io.crate.blob.recovery.BlobRecoveryHandler;
import io.crate.blob.transfer.BlobHeadRequestHandler;
import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.plugin.PipelineRegistry;
import io.crate.protocols.http.HttpBlobHandler;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty4.cors.Netty4CorsConfig;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.PeerRecoverySourceService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.transport.TransportService;

public class BlobService
extends AbstractLifecycleComponent {
    private final BlobIndicesService blobIndicesService;
    private final BlobHeadRequestHandler blobHeadRequestHandler;
    private final PeerRecoverySourceService peerRecoverySourceService;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final BlobTransferTarget blobTransferTarget;
    private final Client client;
    private final PipelineRegistry pipelineRegistry;
    private final Settings settings;

    @Inject
    public BlobService(ClusterService clusterService, BlobIndicesService blobIndicesService, BlobHeadRequestHandler blobHeadRequestHandler, PeerRecoverySourceService peerRecoverySourceService, TransportService transportService, BlobTransferTarget blobTransferTarget, Client client, PipelineRegistry pipelineRegistry, Settings settings) {
        this.clusterService = clusterService;
        this.blobIndicesService = blobIndicesService;
        this.blobHeadRequestHandler = blobHeadRequestHandler;
        this.peerRecoverySourceService = peerRecoverySourceService;
        this.transportService = transportService;
        this.blobTransferTarget = blobTransferTarget;
        this.client = client;
        this.pipelineRegistry = pipelineRegistry;
        this.settings = settings;
    }

    public RemoteDigestBlob newBlob(String index, String digest) {
        assert (this.client != null) : "client for remote digest blob must not be null";
        ShardId shardId = this.clusterService.operationRouting().indexShards(this.clusterService.state(), index, digest, null).shardId();
        return new RemoteDigestBlob(this.client, shardId, digest);
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.pipelineRegistry.addBefore(new PipelineRegistry.ChannelPipelineItem("aggregator", "blob_handler", netty4CorsConfig -> new HttpBlobHandler(this, this.blobIndicesService, (Netty4CorsConfig)netty4CorsConfig)));
        this.blobHeadRequestHandler.registerHandler();
        this.peerRecoverySourceService.registerRecoverySourceHandlerProvider((shard, request, recoveryTarget, fileChunkSizeInBytes) -> {
            if (!BlobIndex.isBlobIndex(shard.shardId().getIndexName())) {
                return null;
            }
            return new BlobRecoveryHandler(shard, recoveryTarget, request, fileChunkSizeInBytes, RecoverySettings.INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING.get(this.settings), this.transportService, this.blobTransferTarget, this.blobIndicesService);
        });
    }

    @Override
    protected void doStop() throws ElasticsearchException {
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    public String getRedirectAddress(String index, String digest) throws MissingHTTPEndpointException {
        ShardRouting shard;
        ShardIterator shards = this.clusterService.operationRouting().getShards(this.clusterService.state(), index, null, digest, "_local");
        String localNodeId = this.clusterService.localNode().getId();
        DiscoveryNodes nodes = this.clusterService.state().getNodes();
        while ((shard = shards.nextOrNull()) != null) {
            if (!shard.active()) continue;
            if (shard.currentNodeId().equals(localNodeId)) {
                return null;
            }
            DiscoveryNode node = nodes.get(shard.currentNodeId());
            String httpAddress = node.getAttributes().get("http_address");
            if (httpAddress == null) continue;
            return httpAddress + "/_blobs/" + BlobIndex.stripPrefix(index) + "/" + digest;
        }
        throw new MissingHTTPEndpointException("Can't find a suitable http server to serve the blob");
    }
}

