/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth.user;

import io.crate.analyze.user.Privilege;
import io.crate.analyze.user.PrivilegeIdent;
import io.crate.metadata.IndexParts;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class UserPrivileges
implements Iterable<Privilege> {
    private final Map<PrivilegeIdent, Privilege> privilegeByIdent;
    private final boolean anyClusterPrivilege;
    private final Set<String> anySchemaPrivilege = new HashSet<String>();
    private final Set<String> anyTablePrivilege = new HashSet<String>();
    private final Set<String> anyViewPrivilege = new HashSet<String>();

    UserPrivileges(Collection<Privilege> privileges) {
        this.privilegeByIdent = new HashMap<PrivilegeIdent, Privilege>(privileges.size());
        boolean anyClusterPrivilege = false;
        block6: for (Privilege privilege : privileges) {
            PrivilegeIdent privilegeIdent = privilege.ident();
            this.privilegeByIdent.put(privilegeIdent, privilege);
            if (privilege.state() == Privilege.State.DENY) continue;
            switch (privilegeIdent.clazz()) {
                case CLUSTER: {
                    anyClusterPrivilege = true;
                    continue block6;
                }
                case SCHEMA: {
                    this.anySchemaPrivilege.add(privilegeIdent.ident());
                    continue block6;
                }
                case TABLE: {
                    this.anyTablePrivilege.add(privilegeIdent.ident());
                    continue block6;
                }
                case VIEW: {
                    this.anyViewPrivilege.add(privilegeIdent.ident());
                    continue block6;
                }
            }
            throw new IllegalStateException("Unsupported privilege class=" + privilegeIdent.clazz());
        }
        this.anyClusterPrivilege = anyClusterPrivilege;
    }

    boolean matchPrivilegeOfAnyType(Privilege.Clazz clazz, @Nullable String ident) {
        boolean foundPrivilege;
        switch (clazz) {
            case CLUSTER: {
                foundPrivilege = this.hasAnyClusterPrivilege();
                break;
            }
            case SCHEMA: {
                foundPrivilege = this.hasAnySchemaPrivilege(ident);
                if (foundPrivilege) break;
                foundPrivilege = this.hasAnyClusterPrivilege();
                break;
            }
            case TABLE: {
                String schemaIdent;
                foundPrivilege = this.hasAnyTablePrivilege(ident);
                if (foundPrivilege || (foundPrivilege = this.hasAnySchemaPrivilege(schemaIdent = new IndexParts(ident).getSchema()))) break;
                foundPrivilege = this.hasAnyClusterPrivilege();
                break;
            }
            case VIEW: {
                String schemaIdent;
                foundPrivilege = this.hasAnyViewPrivilege(ident);
                if (foundPrivilege || (foundPrivilege = this.hasAnySchemaPrivilege(schemaIdent = new IndexParts(ident).getSchema()))) break;
                foundPrivilege = this.hasAnyClusterPrivilege();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported privilege class=" + clazz);
            }
        }
        return foundPrivilege;
    }

    boolean matchPrivilege(@Nullable Privilege.Type type, Privilege.Clazz clazz, @Nullable String ident, String defaultSchema) {
        Privilege foundPrivilege = this.privilegeByIdent.get(new PrivilegeIdent(type, clazz, ident));
        if (foundPrivilege == null) {
            switch (clazz) {
                case SCHEMA: {
                    foundPrivilege = this.privilegeByIdent.get(new PrivilegeIdent(type, Privilege.Clazz.CLUSTER, null));
                    break;
                }
                case TABLE: 
                case VIEW: {
                    String schemaIdent = new IndexParts(ident, defaultSchema).getSchema();
                    foundPrivilege = this.privilegeByIdent.get(new PrivilegeIdent(type, Privilege.Clazz.SCHEMA, schemaIdent));
                    if (foundPrivilege != null) break;
                    foundPrivilege = this.privilegeByIdent.get(new PrivilegeIdent(type, Privilege.Clazz.CLUSTER, null));
                    break;
                }
            }
        }
        if (foundPrivilege == null) {
            return false;
        }
        switch (foundPrivilege.state()) {
            case GRANT: {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public Iterator<Privilege> iterator() {
        return this.privilegeByIdent.values().iterator();
    }

    private boolean hasAnyClusterPrivilege() {
        return this.anyClusterPrivilege;
    }

    private boolean hasAnySchemaPrivilege(String ident) {
        return this.anySchemaPrivilege.contains(ident);
    }

    private boolean hasAnyTablePrivilege(String ident) {
        return this.anyTablePrivilege.contains(ident);
    }

    private boolean hasAnyViewPrivilege(String ident) {
        return this.anyViewPrivilege.contains(ident);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPrivileges that = (UserPrivileges)o;
        return this.privilegeByIdent.equals(that.privilegeByIdent);
    }

    public int hashCode() {
        return this.privilegeByIdent.hashCode();
    }

    public int size() {
        return this.privilegeByIdent.size();
    }
}

